#!/bin/sh

FILES=`ls *.ps`
for F in $FILES; do
	echo "converting ${F}"
	FNOPS="`basename $F .ps`"
	echo "   to ${FNOPS}.pdf"
	ps2pdf -dOptimize=true -dEmbedAllFonts=true ${F} "${FNOPS}.pdf"
	echo "   to ${FNOPS}.svg"
	inkscape "${FNOPS}.pdf" --export-plain-svg="${FNOPS}.svg"
	# PNG generation - no longer needed
	#gs -q -r800 -dSAFER -dBATCH -dNOPAUSE -dNOCACHE -sDEVICE=pnggray -sOutputFile="${FNOPS}.png" "${F}"
done
