/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;

public class Graph {
    boolean bupdate = false;
    boolean boverlay = false;
    boolean bxmajor = false;
    boolean bxminor = false;
    boolean bxlabels = false;
    boolean bymajor = false;
    boolean byminor = false;
    boolean bylabels = false;
    float[] data = new float[]{0.0f, 0.0f};
    float[] datao = new float[]{0.0f, 0.0f};
    float dmin = 0.0f;
    float dres = 0.0f;
    float domin = 0.0f;
    float dores = 0.0f;
    float xmin = 0.0f;
    float xmax = 0.0f;
    float xscale = 0.0f;
    float ymin = 0.0f;
    float ymax = 0.0f;
    float yscale = 0.0f;
    int width = 0;
    int height = 0;
    String xunit = "";
    String yunit = "";
    Color cbackg = Color.black;
    Color cgraph = Color.red;
    Color cgover = new Color(150, 150, 255);
    Color cmajor = Color.white;
    Color cminor = Color.darkGray;
    Color ctext = Color.white;
    Container con;
    Image image;

    public Graph(Container c) {
        this.con = c;
    }

    public int getCoordinate(int x) {
        return this.getYCoordinate(this.getValue(x));
    }

    public Image getImage() {
        if (this.bupdate) {
            this.drawImage();
        }
        return this.image;
    }

    public float getXValue(int x) {
        return this.xmin + (float)x * this.xscale;
    }

    public float getValue(int x) {
        if (this.dres == 0.0f) {
            return 0.0f;
        }
        float f = (this.getXValue(x) - this.dmin) / this.dres;
        if ((int)f < 0 || (int)f + 1 > this.data.length - 1) {
            return 0.0f;
        }
        return this.data[(int)f] + (this.data[(int)f + 1] - this.data[(int)f]) * (f - (float)((int)f));
    }

    public void hideOverlay() {
        this.boverlay = false;
        this.bupdate = true;
    }

    public void saveOverlay() {
        int dl = this.data.length;
        this.datao = new float[dl];
        System.arraycopy(this.data, 0, this.datao, 0, dl);
        this.domin = this.dmin;
        this.dores = this.dres;
        this.boverlay = true;
        this.bupdate = true;
    }

    public void setColors(Color bkg, Color grp, Color ovr, Color maj, Color min, Color txt) {
        this.cbackg = bkg;
        this.cgraph = grp;
        this.cgover = ovr;
        this.cmajor = maj;
        this.cminor = min;
        this.ctext = txt;
        this.bupdate = true;
    }

    public void setData(float[] d, float min, float res) {
        int dl = d.length;
        this.data = new float[dl];
        System.arraycopy(d, 0, this.data, 0, dl);
        this.dmin = min;
        this.dres = res;
        this.bupdate = true;
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
        if (w > 0 && h > 36) {
            this.image = this.con.createImage(w, h);
            this.bupdate = true;
        } else {
            this.image = null;
        }
    }

    public void setXAxis(float fmin, float fmax, boolean bmaj, boolean bmin, boolean blab, String s) {
        this.xmin = fmin;
        this.xmax = fmax;
        this.bxmajor = bmaj;
        this.bxminor = bmin;
        this.bxlabels = blab;
        this.xunit = " " + s;
        this.bupdate = true;
    }

    public void setYAxis(float fmin, float fmax, boolean bmaj, boolean bmin, boolean blab, String s) {
        this.ymin = fmin;
        this.ymax = fmax;
        this.bymajor = bmaj;
        this.byminor = bmin;
        this.bylabels = blab;
        this.yunit = " " + s;
        this.bupdate = true;
    }

    private void drawImage() {
        int y2;
        int y1;
        float f;
        float min;
        int x;
        float max;
        if (this.image == null) {
            return;
        }
        this.bupdate = false;
        float xmajor = 1.0f;
        float xminor = 1.0f;
        float ymajor = 1.0f;
        float yminor = 1.0f;
        Graphics g = this.image.getGraphics();
        g.setColor(this.cbackg);
        g.fillRect(0, 0, this.width, this.height);
        float f2 = this.xscale = this.xmin != this.xmax ? (this.xmax - this.xmin) / (float)this.width : this.dres;
        if (this.ymin != this.ymax) {
            this.yscale = (this.ymax - this.ymin) / (float)(this.height - 36);
        } else {
            max = this.getValue(0);
            x = 1;
            while (x < this.width) {
                max = Math.max(max, this.getValue(x));
                ++x;
            }
            this.yscale = (max - this.ymin) / (float)(this.height - 36);
        }
        if (this.bxlabels || this.bxmajor || this.bxminor) {
            float xl = (float)(Math.log(this.xscale) / Math.log(10.0)) + 2.3f;
            float xli = (int)Math.floor(xl);
            float xlf = (float)Math.pow(10.0, xli);
            float xlr = xl - xli;
            if ((double)xlr < 0.3) {
                xmajor = xlf;
                xminor = xlf * 0.2f;
            } else if ((double)xlr < 0.7) {
                xmajor = xlf * 2.0f;
                xminor = xlf * 0.5f;
            } else {
                xmajor = xlf * 5.0f;
                xminor = xlf;
            }
        }
        if (this.bylabels || this.bymajor || this.byminor) {
            float yl = (float)(Math.log(this.yscale) / Math.log(10.0)) + 2.3f;
            float yli = (int)Math.floor(yl);
            float ylf = (float)Math.pow(10.0, yli);
            float ylr = yl - yli;
            if ((double)ylr < 0.3) {
                ymajor = ylf;
                yminor = ylf * 0.2f;
            } else if ((double)ylr < 0.7) {
                ymajor = ylf * 2.0f;
                yminor = ylf * 0.5f;
            } else {
                ymajor = ylf * 5.0f;
                yminor = ylf;
            }
        }
        g.setColor(this.cminor);
        if (this.bxminor) {
            min = this.xmin - (float)Math.IEEEremainder(this.xmin, xminor);
            if (min < this.xmin) {
                min += xminor;
            }
            max = this.xmin + this.xscale * (float)this.width;
            f = min;
            while (f < max) {
                g.drawLine(this.getXCoordinate(f), 0, this.getXCoordinate(f), this.height - 36);
                f += xminor;
            }
        }
        if (this.byminor) {
            min = this.ymin - (float)Math.IEEEremainder(this.ymin, yminor);
            if (min < this.ymin) {
                min += yminor;
            }
            max = this.ymin + this.yscale * (float)(this.height - 36);
            f = min;
            while (f < max) {
                g.drawLine(0, this.getYCoordinate(f), this.width - 1, this.getYCoordinate(f));
                f += yminor;
            }
        }
        if (this.bxmajor || this.bxlabels) {
            min = this.xmin - (float)Math.IEEEremainder(this.xmin, xmajor);
            if (min < this.xmin) {
                min += xmajor;
            }
            max = this.xmin + this.xscale * (float)this.width;
            if (this.bxlabels) {
                g.setColor(this.ctext);
                f = min;
                while (f < max) {
                    g.drawString(String.valueOf(f) + this.xunit, this.getXCoordinate(f), this.height - 20);
                    f += xmajor;
                }
            }
            if (this.bxmajor) {
                g.setColor(this.cmajor);
                f = min;
                while (f < max) {
                    g.drawLine(this.getXCoordinate(f), 0, this.getXCoordinate(f), this.height - 36);
                    f += xmajor;
                }
            }
        }
        if (this.bymajor || this.bylabels) {
            min = this.ymin - (float)Math.IEEEremainder(this.ymin, ymajor);
            if (min < this.ymin) {
                min += ymajor;
            }
            max = this.ymin + this.yscale * (float)(this.height - 36);
            if (this.bymajor) {
                g.setColor(this.cmajor);
                f = min;
                while (f < max) {
                    g.drawLine(0, this.getYCoordinate(f), this.width - 1, this.getYCoordinate(f));
                    f += ymajor;
                }
            }
            if (this.bylabels) {
                g.setColor(this.ctext);
                f = min;
                while (f < max) {
                    g.drawString(String.valueOf(f) + this.yunit, 0, this.getYCoordinate(f));
                    f += ymajor;
                }
            }
        }
        if (this.boverlay) {
            g.setColor(this.cgover);
            x = 1;
            y1 = this.getOverlayCoordinate(0);
            while (x < this.width) {
                y2 = this.getOverlayCoordinate(x);
                g.drawLine(x - 1, y1, x, y2);
                y1 = y2;
                ++x;
            }
        }
        g.setColor(this.cgraph);
        x = 1;
        y1 = this.getCoordinate(0);
        while (x < this.width) {
            y2 = this.getCoordinate(x);
            g.drawLine(x - 1, y1, x, y2);
            y1 = y2;
            ++x;
        }
    }

    private int getOverlayCoordinate(int x) {
        return this.getYCoordinate(this.getOverlayValue(x));
    }

    private float getOverlayValue(int x) {
        if (this.dores == 0.0f) {
            return 0.0f;
        }
        float f = (this.getXValue(x) - this.domin) / this.dores;
        if ((int)f < 0 || (int)f + 1 > this.datao.length - 1) {
            return 0.0f;
        }
        return this.datao[(int)f] + (this.datao[(int)f + 1] - this.datao[(int)f]) * (f - (float)((int)f));
    }

    private int getXCoordinate(float x) {
        return this.xscale == 0.0f ? 0 : Math.round((x - this.xmin) / this.xscale);
    }

    private int getYCoordinate(float y) {
        return this.yscale == 0.0f ? 0 : Math.round((float)(this.height - 36) - (y - this.ymin) / this.yscale);
    }
}

