/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;

public class FourierAnalyzer
extends Frame
implements ActionListener,
ComponentListener,
MouseListener,
MouseMotionListener,
WindowListener {
    final int datalength = 8192;
    final int framesize = 2;
    final int samplingfreq = 44100;
    boolean pause = false;
    int xmouse = -1;
    AudioCanvas ac;
    Dimension acSize;
    Image image;
    Graph waveform;
    Graph frequency;
    PopupMenu popup = new PopupMenu();
    MenuItem mwdefault;
    MenuItem mw10;
    MenuItem mw20;
    MenuItem mw50;
    MenuItem madefault;
    MenuItem ma2;
    MenuItem ma5;
    MenuItem ma10;
    MenuItem mfdefault;
    MenuItem mf2000;
    MenuItem mf5000;
    MenuItem mf10000;
    MenuItem mosave;
    MenuItem moclear;

    public static void main(String[] args) {
        new FourierAnalyzer();
    }

    public FourierAnalyzer() {
        super("Fourier Analyzer");
        this.add(this.popup);
        this.mwdefault = new MenuItem("Set Waveform to Default Timescale");
        this.popup.add(this.mwdefault);
        this.mw10 = new MenuItem("Set Waveform to 10 ms");
        this.popup.add(this.mw10);
        this.mw20 = new MenuItem("Set Waveform to 20 ms");
        this.popup.add(this.mw20);
        this.mw50 = new MenuItem("Set Waveform to 50 ms");
        this.popup.add(this.mw50);
        this.madefault = new MenuItem("Set Waveform to Default Amplitude");
        this.popup.add(this.madefault);
        this.ma2 = new MenuItem("Set Waveform to 2x Amplitude");
        this.popup.add(this.ma2);
        this.ma5 = new MenuItem("Set Waveform to 5x Amplitude");
        this.popup.add(this.ma5);
        this.ma10 = new MenuItem("Set Waveform to 10x Amplitude");
        this.popup.add(this.ma10);
        this.mfdefault = new MenuItem("Set Frequency to Default");
        this.popup.add(this.mfdefault);
        this.mf2000 = new MenuItem("Set Frequency to 2000 Hz");
        this.popup.add(this.mf2000);
        this.mf5000 = new MenuItem("Set Frequency to 5000 Hz");
        this.popup.add(this.mf5000);
        this.mf10000 = new MenuItem("Set Frequency to 10000 Hz");
        this.popup.add(this.mf10000);
        this.mosave = new MenuItem("Save Data");
        this.popup.add(this.mosave);
        this.moclear = new MenuItem("Clear Saved Data");
        this.popup.add(this.moclear);
        this.mwdefault.addActionListener(this);
        this.mw10.addActionListener(this);
        this.mw20.addActionListener(this);
        this.mw50.addActionListener(this);
        this.madefault.addActionListener(this);
        this.ma2.addActionListener(this);
        this.ma5.addActionListener(this);
        this.ma10.addActionListener(this);
        this.mfdefault.addActionListener(this);
        this.mf2000.addActionListener(this);
        this.mf5000.addActionListener(this);
        this.mf10000.addActionListener(this);
        this.mosave.addActionListener(this);
        this.moclear.addActionListener(this);
        this.ac = new AudioCanvas();
        this.add(this.ac);
        this.ac.setBackground(Color.black);
        this.ac.setForeground(Color.white);
        this.ac.addComponentListener(this);
        this.ac.addMouseListener(this);
        this.ac.addMouseMotionListener(this);
        this.addWindowListener(this);
        this.waveform = new Graph(this);
        this.waveform.setXAxis(0.0f, 0.0f, true, true, true, "ms");
        this.waveform.setYAxis(-((float)Math.pow(256.0, 2.0)) / 2.0f, (float)Math.pow(256.0, 2.0) / 2.0f, true, true, false, "");
        this.frequency = new Graph(this);
        this.frequency.setXAxis(20.0f, 20.0f, true, true, true, "Hz");
        this.frequency.setYAxis(0.0f, 0.0f, true, true, false, "");
        this.setSize(600, 500);
        this.handleResize();
        this.setVisible(true);
        new AudioThread().start();
    }

    public void handleResize() {
        this.acSize = this.ac.getSize();
        if (this.acSize.width > 0 && this.acSize.height > 0) {
            this.image = this.createImage(this.acSize.width, this.acSize.height);
            this.waveform.setSize(this.acSize.width, this.acSize.height / 2);
            this.frequency.setSize(this.acSize.width, this.acSize.height - this.acSize.height / 2);
        }
    }

    @Override
    public void update(Graphics g) {
        this.ac.repaint();
    }

    @Override
    public void paint(Graphics g) {
        this.ac.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mwdefault) {
            this.waveform.setXAxis(0.0f, 0.0f, true, true, true, "ms");
        } else if (e.getSource() == this.mw10) {
            this.waveform.setXAxis(0.0f, 10.0f, true, true, true, "ms");
        } else if (e.getSource() == this.mw20) {
            this.waveform.setXAxis(0.0f, 20.0f, true, true, true, "ms");
        } else if (e.getSource() == this.mw50) {
            this.waveform.setXAxis(0.0f, 50.0f, true, true, true, "ms");
        } else if (e.getSource() == this.madefault) {
            this.waveform.setYAxis(-((float)Math.pow(256.0, 2.0)) / 2.0f, (float)Math.pow(256.0, 2.0) / 2.0f, true, true, false, "");
        } else if (e.getSource() == this.ma2) {
            this.waveform.setYAxis(-((float)Math.pow(256.0, 2.0)) / 4.0f, (float)Math.pow(256.0, 2.0) / 4.0f, true, true, false, "");
        } else if (e.getSource() == this.ma5) {
            this.waveform.setYAxis(-((float)Math.pow(256.0, 2.0)) / 10.0f, (float)Math.pow(256.0, 2.0) / 10.0f, true, true, false, "");
        } else if (e.getSource() == this.ma10) {
            this.waveform.setYAxis(-((float)Math.pow(256.0, 2.0)) / 20.0f, (float)Math.pow(256.0, 2.0) / 20.0f, true, true, false, "");
        } else if (e.getSource() == this.mfdefault) {
            this.frequency.setXAxis(20.0f, 20.0f, true, true, true, "Hz");
        } else if (e.getSource() == this.mf2000) {
            this.frequency.setXAxis(20.0f, 2000.0f, true, true, true, "Hz");
        } else if (e.getSource() == this.mf5000) {
            this.frequency.setXAxis(20.0f, 5000.0f, true, true, true, "Hz");
        } else if (e.getSource() == this.mf10000) {
            this.frequency.setXAxis(20.0f, 10000.0f, true, true, true, "Hz");
        } else if (e.getSource() == this.mosave) {
            this.waveform.saveOverlay();
            this.frequency.saveOverlay();
        } else if (e.getSource() == this.moclear) {
            this.waveform.hideOverlay();
            this.frequency.hideOverlay();
        }
        this.ac.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.ac.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.handleResize();
        this.ac.repaint(50L);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.xmouse = -1;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.xmouse = e.getX();
        this.ac.repaint(50L);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        } else {
            boolean bl = this.pause = !this.pause;
            if (!this.pause) {
                new AudioThread().start();
            }
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
        System.exit(0);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    class AudioCanvas
    extends Canvas {
        AudioCanvas() {
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public void paint(Graphics acg) {
            if (FourierAnalyzer.this.image == null) {
                return;
            }
            Graphics g = FourierAnalyzer.this.image.getGraphics();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, FourierAnalyzer.this.acSize.width, FourierAnalyzer.this.acSize.height);
            g.drawImage(FourierAnalyzer.this.waveform.getImage(), 0, 0, this);
            g.drawImage(FourierAnalyzer.this.frequency.getImage(), 0, FourierAnalyzer.this.acSize.height / 2, this);
            g.setColor(this.getForeground());
            if (FourierAnalyzer.this.xmouse != -1) {
                g.drawString("time: " + (float)Math.round(FourierAnalyzer.this.waveform.getXValue(FourierAnalyzer.this.xmouse) * 100.0f) / 100.0f + " ms, amplitude: " + Math.round(FourierAnalyzer.this.waveform.getValue(FourierAnalyzer.this.xmouse)), 0, FourierAnalyzer.this.acSize.height / 2 - 5);
                g.drawString("frequency: " + Math.round(FourierAnalyzer.this.frequency.getXValue(FourierAnalyzer.this.xmouse)) + " Hz, magnitude: " + (float)Math.round(FourierAnalyzer.this.frequency.getValue(FourierAnalyzer.this.xmouse) * 1000.0f) / 1000.0f, 0, FourierAnalyzer.this.acSize.height - 5);
                int y = FourierAnalyzer.this.waveform.getCoordinate(FourierAnalyzer.this.xmouse);
                g.drawLine(FourierAnalyzer.this.xmouse - 3, y - 3, FourierAnalyzer.this.xmouse + 3, y + 3);
                g.drawLine(FourierAnalyzer.this.xmouse - 3, y + 3, FourierAnalyzer.this.xmouse + 3, y - 3);
                y = FourierAnalyzer.this.frequency.getCoordinate(FourierAnalyzer.this.xmouse) + FourierAnalyzer.this.acSize.height / 2;
                g.drawLine(FourierAnalyzer.this.xmouse - 3, y - 3, FourierAnalyzer.this.xmouse + 3, y + 3);
                g.drawLine(FourierAnalyzer.this.xmouse - 3, y + 3, FourierAnalyzer.this.xmouse + 3, y - 3);
            }
            acg.drawImage(FourierAnalyzer.this.image, 0, 0, this);
        }
    }

    class AudioThread
    extends Thread {
        byte[] temp = new byte[16384];
        float[] wdata;
        float[] fdata;

        AudioThread() {
        }

        @Override
        public void run() {
            try {
                AudioFormat af = new AudioFormat(44100.0f, 16, 1, true, false);
                TargetDataLine tdl = (TargetDataLine)AudioSystem.getLine(new DataLine.Info(TargetDataLine.class, af));
                tdl.open(af);
                tdl.start();
                while (!FourierAnalyzer.this.pause) {
                    int c = tdl.read(this.temp, 0, this.temp.length);
                    if (c <= 0) continue;
                    int dl = 1;
                    int t = c / 2;
                    while (t >= dl * 2) {
                        dl *= 2;
                    }
                    this.wdata = new float[dl];
                    int i = 0;
                    while (i < 2) {
                        float p = (float)Math.pow(256.0, i);
                        int j = 0;
                        while (j < dl) {
                            int n = j;
                            this.wdata[n] = this.wdata[n] + (float)this.temp[j * 2 + i] * p;
                            ++j;
                        }
                        ++i;
                    }
                    this.fdata = new float[dl];
                    FFT.transform(this.wdata, this.fdata);
                    FourierAnalyzer.this.waveform.setData(this.wdata, 0.0f, 0.022675738f);
                    FourierAnalyzer.this.frequency.setData(this.fdata, 0.0f, 44100.0f / (float)dl);
                    FourierAnalyzer.this.ac.repaint();
                }
                tdl.stop();
                tdl.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
    }
}

