/*
 * Decompiled with CFR 0.152.
 */
public class FFT {
    public static void transform(float[] data, float[] magn) {
        int dl = data.length;
        System.arraycopy(data, 0, magn, 0, dl);
        float[] imag = new float[dl];
        FFT.complex(1, dl, magn, imag);
        int c = 0;
        while (c < dl) {
            magn[c] = (float)Math.sqrt(magn[c] * magn[c] + imag[c] * imag[c]) / (float)dl;
            ++c;
        }
    }

    public static void transform(float[] data, float[] real, float[] imag, float[] magn, float[] angl) {
        int dl = data.length;
        System.arraycopy(data, 0, real, 0, dl);
        FFT.complex(1, dl, real, imag);
        int c = 0;
        while (c < dl) {
            magn[c] = (float)Math.sqrt(real[c] * real[c] + imag[c] * imag[c]) / (float)dl;
            angl[c] = (double)real[c] == 0.0 || (double)imag[c] == 0.0 ? 0.0f : (float)(Math.atan(imag[c] / real[c]) * 180.0 / Math.PI);
            if ((double)real[c] < 0.0) {
                if ((double)imag[c] < 0.0) {
                    int n = c;
                    angl[n] = (float)((double)angl[n] - 180.0);
                } else {
                    int n = c;
                    angl[n] = (float)((double)angl[n] + 180.0);
                }
            }
            ++c;
        }
    }

    public static void complex(int dir, int len, float[] real, float[] imag) {
        int i = 0;
        int j = 0;
        while (i < len) {
            if (j >= i) {
                float tr = real[j];
                float ti = imag[j];
                real[j] = real[i];
                imag[j] = imag[i];
                real[i] = tr;
                imag[i] = ti;
            }
            int m = len / 2;
            while (m >= 1 && j >= m) {
                j -= m;
                m /= 2;
            }
            j += m;
            ++i;
        }
        int max = 1;
        int step = 2;
        while (max < len) {
            float angle = (float)dir * (float)Math.PI / (float)max;
            int c = 0;
            while (c < max) {
                float anglec = angle * (float)c;
                float cr = (float)Math.cos(anglec);
                float ci = (float)Math.sin(anglec);
                int r = 0;
                int l = c;
                while (l < len) {
                    r = l + max;
                    float tr = cr * real[r] - ci * imag[r];
                    float ti = cr * imag[r] + ci * real[r];
                    real[r] = real[l] - tr;
                    imag[r] = imag[l] - ti;
                    int n = l;
                    real[n] = real[n] + tr;
                    int n2 = l;
                    imag[n2] = imag[n2] + ti;
                    l += step;
                }
                ++c;
            }
            max = step;
            step = 2 * max;
        }
    }
}

