/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Scrollbar;

public class FourierLayout
implements LayoutManager {
    FourierLayout() {
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return new Dimension(500, 500);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return new Dimension(100, 100);
    }

    @Override
    public void layoutContainer(Container target) {
        int barwidth = 0;
        int i = 1;
        while (i < target.getComponentCount()) {
            Component m = target.getComponent(i);
            if (m.isVisible()) {
                Dimension d = m.getPreferredSize();
                if (d.width > barwidth) {
                    barwidth = d.width;
                }
            }
            ++i;
        }
        Insets insets = target.getInsets();
        int targetw = target.getSize().width - insets.left - insets.right;
        int cw = targetw - barwidth;
        int targeth = target.getSize().height - insets.top - insets.bottom;
        target.getComponent(0).setLocation(insets.left, insets.top);
        target.getComponent(0).setSize(cw, targeth);
        cw += insets.left;
        int h = insets.top;
        i = 1;
        while (i < target.getComponentCount()) {
            Component m = target.getComponent(i);
            if (m.isVisible()) {
                Dimension d = m.getPreferredSize();
                if (m instanceof Scrollbar) {
                    d.width = barwidth;
                }
                if (m instanceof Label) {
                    h += d.height / 5;
                    d.width = barwidth;
                }
                m.setLocation(cw, h);
                m.setSize(d.width, d.height);
                h += d.height;
            }
            ++i;
        }
    }

    @Override
    public void addLayoutComponent(String name, Component c) {
    }

    @Override
    public void removeLayoutComponent(Component c) {
    }
}

