/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class FourierFrame
extends Frame
implements ComponentListener,
ActionListener,
AdjustmentListener,
KeyListener,
MouseMotionListener,
MouseListener,
ItemListener,
WindowListener {
    Fourier applet;
    FourierCanvas cv;
    PlayThread playThread;
    FFT fft;
    NumberFormat ampFormat;
    NumberFormat phaseFormat;
    NumberFormat dbFormat;
    NumberFormat tableAFormat;
    NumberFormat tablePFormat;
    Dimension winSize;
    Image dbimage;
    Button sineButton;
    Button cosineButton;
    Button triangleButton;
    Button sawtoothButton;
    Button squareButton;
    Button noiseButton;
    Button phaseButton;
    Button clipButton;
    Button resampleButton;
    Button quantizeButton;
    Button rectButton;
    Button fullRectButton;
    Button blankButton;
    Button saveButton;
    Checkbox soundCheck;
    Checkbox logCheck;
    Checkbox saveCheck;
    Checkbox superCheck;
    Label termLabel;
    Label freqLabel;
    Scrollbar termBar;
    Scrollbar freqBar;
    double[] ampcoef;
    double[] phasecoef;
    double[] saveAmpcoef;
    double[] savePhasecoef;
    double[] func;
    double[] origFunc;
    double ymultFunc;
    double ymultAmps;
    double ymultPhas;
    boolean[] mutes;
    boolean[] solos;
    boolean hasSolo;
    boolean dragging;
    int selHarm;
    int sel;
    int dragX;
    int dragY;
    int quantizeCount;
    int resampleCount;
    int dfreq0;
    int graphHeight;
    int yzeroFunc;
    int yzeroAmps;
    int yzeroPhas;
    final int SEL_NONE = 0;
    final int SEL_FUNC = 1;
    final int SEL_AMPS = 2;
    final int SEL_PHAS = 3;
    final int SEL_MUTE = 4;
    final int SEL_SOLO = 5;
    final int maxTerms = 160;
    final int rate = 22050;
    final int playSampleCount = 4096;
    final int sampleCount = 1024;
    final int halfSampleCount = 512;
    final double halfSampleCountFloat = 512.0;
    final double pi = Math.PI;
    final double step = 0.006135923151542565;

    FourierFrame(Fourier a) {
        super("Fourier Analysis - UW Madison Physics in the Arts");
        this.applet = a;
    }

    public void init() {
        this.addWindowListener(this);
        this.selHarm = -1;
        this.ampcoef = new double[160];
        this.phasecoef = new double[160];
        this.saveAmpcoef = new double[160];
        this.savePhasecoef = new double[160];
        this.mutes = new boolean[160];
        this.solos = new boolean[160];
        this.func = new double[1025];
        this.setLayout(new FourierLayout());
        this.cv = new FourierCanvas(this);
        this.add(this.cv);
        this.cv.addComponentListener(this);
        this.cv.addKeyListener(this);
        this.cv.addMouseMotionListener(this);
        this.cv.addMouseListener(this);
        this.add(new Label("Functions", 1));
        this.sineButton = new Button("Sine");
        this.add(this.sineButton);
        this.sineButton.addActionListener(this);
        this.cosineButton = new Button("Cosine");
        this.add(this.cosineButton);
        this.cosineButton.addActionListener(this);
        this.triangleButton = new Button("Triangle");
        this.add(this.triangleButton);
        this.triangleButton.addActionListener(this);
        this.sawtoothButton = new Button("Sawtooth");
        this.add(this.sawtoothButton);
        this.sawtoothButton.addActionListener(this);
        this.squareButton = new Button("Square");
        this.add(this.squareButton);
        this.squareButton.addActionListener(this);
        this.noiseButton = new Button("Noise");
        this.add(this.noiseButton);
        this.noiseButton.addActionListener(this);
        this.add(new Label("Effects", 1));
        this.phaseButton = new Button("Phase Shift");
        this.add(this.phaseButton);
        this.phaseButton.addActionListener(this);
        this.clipButton = new Button("Clip");
        this.add(this.clipButton);
        this.clipButton.addActionListener(this);
        this.resampleButton = new Button("Resample");
        this.add(this.resampleButton);
        this.resampleButton.addActionListener(this);
        this.quantizeButton = new Button("Quantize");
        this.add(this.quantizeButton);
        this.quantizeButton.addActionListener(this);
        this.rectButton = new Button("Rectify");
        this.add(this.rectButton);
        this.rectButton.addActionListener(this);
        this.fullRectButton = new Button("Full Rectify");
        this.add(this.fullRectButton);
        this.fullRectButton.addActionListener(this);
        this.blankButton = new Button("Clear");
        this.add(this.blankButton);
        this.blankButton.addActionListener(this);
        this.add(new Label("Settings", 1));
        this.soundCheck = new Checkbox("Sound");
        this.add(this.soundCheck);
        this.soundCheck.addItemListener(this);
        this.logCheck = new Checkbox("Log Scale");
        this.add(this.logCheck);
        this.logCheck.addItemListener(this);
        this.termLabel = new Label("Terms: 25", 1);
        this.add(this.termLabel);
        this.termBar = new Scrollbar(0, 25, 1, 1, 160);
        this.add(this.termBar);
        this.termBar.addAdjustmentListener(this);
        this.freqLabel = new Label("Frequency: 220 Hz", 1);
        this.add(this.freqLabel);
        this.freqBar = new Scrollbar(0, 251, 1, 0, 500);
        this.add(this.freqBar);
        this.freqBar.addAdjustmentListener(this);
        this.add(new Label("Second Waveform", 1));
        this.saveButton = new Button("Save Waveform");
        this.add(this.saveButton);
        this.saveButton.addActionListener(this);
        this.saveCheck = new Checkbox("Show Saved Waveform");
        this.add(this.saveCheck);
        this.saveCheck.addItemListener(this);
        this.superCheck = new Checkbox("Show Superposition");
        this.add(this.superCheck);
        this.superCheck.addItemListener(this);
        this.fft = new FFT(1024);
        this.actionSine();
        this.cv.setBackground(Color.black);
        this.cv.setForeground(Color.lightGray);
        this.ampFormat = DecimalFormat.getInstance();
        this.ampFormat.setMaximumFractionDigits(5);
        this.phaseFormat = DecimalFormat.getInstance();
        this.phaseFormat.setMaximumFractionDigits(3);
        this.dbFormat = DecimalFormat.getInstance();
        this.dbFormat.setMaximumFractionDigits(2);
        this.tableAFormat = DecimalFormat.getInstance();
        this.tableAFormat.setMaximumFractionDigits(3);
        this.tablePFormat = DecimalFormat.getInstance();
        this.tablePFormat.setMaximumFractionDigits(0);
        this.setSize(800, 740);
        this.handleResize();
        Dimension x = this.getSize();
        Dimension screen = this.getToolkit().getScreenSize();
        this.setLocation((screen.width - x.width) / 2, (screen.height - x.height) / 2);
        this.show();
    }

    @Override
    public void paint(Graphics g) {
        this.cv.repaint();
    }

    public void updateFourier(Graphics realg) {
        int t;
        int y;
        int y2;
        int j;
        double dy;
        int x;
        if (this.winSize == null || this.winSize.width == 0) {
            return;
        }
        int ox = -1;
        int oy = -1;
        int terms = this.termBar.getValue();
        int termWidth = this.getTermWidth();
        int dotSize = Math.min(11, termWidth - 3);
        int periodWidth = this.winSize.width / 3;
        double basef = this.getFreq();
        Color gray1 = new Color(76, 76, 76);
        Color gray2 = new Color(127, 127, 127);
        Graphics g = this.dbimage.getGraphics();
        FontMetrics fm = g.getFontMetrics();
        String s1 = "Harmonic";
        String s2 = "Amplitude";
        String s3 = "Phase";
        int xw = Math.max(fm.stringWidth(s1), Math.max(fm.stringWidth(s2), fm.stringWidth(s3)));
        int xl = 10;
        int xr = xl + xw + 10;
        g.setColor(this.cv.getBackground());
        g.fillRect(0, 0, this.winSize.width, this.winSize.height);
        int i = -1;
        while (i <= 1) {
            g.setColor(i == 0 ? gray2 : gray1);
            g.drawLine(0, this.yzeroFunc + i * (int)this.ymultFunc, this.winSize.width, this.yzeroFunc + i * (int)this.ymultFunc);
            ++i;
        }
        i = 2;
        while (i <= 4) {
            g.setColor(i == 3 ? gray2 : gray1);
            g.drawLine(periodWidth * i / 2, this.yzeroFunc - (int)this.ymultFunc, periodWidth * i / 2, this.yzeroFunc + (int)this.ymultFunc);
            ++i;
        }
        g.setColor(Color.white);
        i = 0;
        while (i <= terms && xr < this.winSize.width) {
            g.drawString(s1, xl, 2 * this.graphHeight + 28);
            g.drawString(s2, xl, 2 * this.graphHeight + 43);
            g.drawString(s3, xl, 2 * this.graphHeight + 58);
            xl = xr;
            s2 = this.tableAFormat.format(this.ampcoef[i]);
            if (s2.equals("0")) {
                s3 = "";
                s2 = "";
                s1 = "";
            } else {
                s1 = String.valueOf(i);
                s3 = i == 0 ? "" : String.valueOf(this.tablePFormat.format(this.phasecoef[i] * 180.0 / Math.PI)) + '\u00b0';
                if (i == this.selHarm && (xr += Math.max(fm.stringWidth(s1), Math.max(fm.stringWidth(s2), fm.stringWidth(s3))) + 10) < this.winSize.width) {
                    g.setColor(Color.yellow);
                    int f = (int)(this.getFreq() * (double)this.selHarm);
                    g.drawString(String.valueOf(f) + (f > 11025 ? " Hz (filtered)" : " Hz"), xl, 2 * this.graphHeight + 13);
                } else {
                    g.setColor(Color.white);
                }
            }
            ++i;
        }
        if (!this.dragging || this.sel == 1) {
            g.setColor(Color.white);
            i = 0;
            while (i != 1025) {
                x = periodWidth * i / 1024;
                int y3 = this.yzeroFunc - (int)(this.ymultFunc * this.func[i]);
                if (ox != -1) {
                    g.drawLine(ox, oy, x, y3);
                    g.drawLine(ox + periodWidth, oy, x + periodWidth, y3);
                    g.drawLine(ox + periodWidth * 2, oy, x + periodWidth * 2, y3);
                }
                ox = x;
                oy = y3;
                ++i;
            }
        }
        if (this.saveCheck.getState()) {
            g.setColor(Color.blue);
            ox = -1;
            i = 0;
            while (i != 1025) {
                x = periodWidth * i / 1024;
                dy = this.saveAmpcoef[0];
                j = 1;
                while (j != terms) {
                    dy += this.saveAmpcoef[j] * Math.cos(0.006135923151542565 * (double)(i - 512) * (double)j + this.getCosSavePhase(j));
                    ++j;
                }
                y2 = this.yzeroFunc - (int)(this.ymultFunc * dy);
                if (ox != -1) {
                    g.drawLine(ox, oy, x, y2);
                    g.drawLine(ox + periodWidth, oy, x + periodWidth, y2);
                    g.drawLine(ox + periodWidth * 2, oy, x + periodWidth * 2, y2);
                }
                ox = x;
                oy = y2;
                ++i;
            }
        }
        if (this.superCheck.getState()) {
            g.setColor(Color.green);
            ox = -1;
            i = 0;
            while (i != 1025) {
                x = periodWidth * i / 1024;
                dy = this.ampcoef[0] + this.saveAmpcoef[0];
                j = 1;
                while (j != terms) {
                    dy += this.ampcoef[j] * Math.cos(0.006135923151542565 * (double)(i - 512) * (double)j + this.getCosPhase(j)) + this.saveAmpcoef[j] * Math.cos(0.006135923151542565 * (double)(i - 512) * (double)j + this.getCosSavePhase(j));
                    ++j;
                }
                y2 = this.yzeroFunc - (int)(this.ymultFunc * dy);
                if (ox != -1) {
                    g.drawLine(ox, oy, x, y2);
                    g.drawLine(ox + periodWidth, oy, x + periodWidth, y2);
                    g.drawLine(ox + periodWidth * 2, oy, x + periodWidth * 2, y2);
                }
                ox = x;
                oy = y2;
                ++i;
            }
        }
        if (!this.dragging || this.sel != 1) {
            g.setColor(Color.red);
            ox = -1;
            i = 0;
            while (i != 1025) {
                x = periodWidth * i / 1024;
                dy = this.ampcoef[0];
                j = 1;
                while (j != terms) {
                    dy += this.ampcoef[j] * Math.cos(0.006135923151542565 * (double)(i - 512) * (double)j + this.getCosPhase(j));
                    ++j;
                }
                y2 = this.yzeroFunc - (int)(this.ymultFunc * dy);
                if (ox != -1) {
                    g.drawLine(ox, oy, x, y2);
                    g.drawLine(ox + periodWidth, oy, x + periodWidth, y2);
                    g.drawLine(ox + periodWidth * 2, oy, x + periodWidth * 2, y2);
                }
                ox = x;
                oy = y2;
                ++i;
            }
        }
        g.setColor(Color.yellow);
        if (this.selHarm != -1) {
            ox = -1;
            double amp = this.ampcoef[this.selHarm];
            if (!this.dragging) {
                if (this.selHarm > 0) {
                    i = 0;
                    while (i != 1025) {
                        x = periodWidth * i / 1024;
                        y = this.yzeroFunc - (int)(this.ymultFunc * amp * Math.cos(0.006135923151542565 * (double)(i - 512) * (double)this.selHarm + this.getCosPhase(this.selHarm)));
                        if (ox != -1) {
                            g.drawLine(ox, oy, x, y);
                            g.drawLine(ox + periodWidth, oy, x + periodWidth, y);
                            g.drawLine(ox + periodWidth * 2, oy, x + periodWidth * 2, y);
                        }
                        ox = x;
                        oy = y;
                        ++i;
                    }
                } else {
                    g.drawLine(0, this.yzeroFunc - (int)(this.ymultFunc * amp), this.winSize.width, this.yzeroFunc - (int)(this.ymultFunc * amp));
                }
            }
        }
        g.setColor(Color.white);
        g.drawString("Amplitudes", (this.winSize.width - fm.stringWidth("Amplitudes")) / 2, 2 * this.graphHeight + 88);
        g.setColor(gray2);
        g.drawLine(0, this.yzeroAmps, this.winSize.width, this.yzeroAmps);
        g.setColor(gray1);
        g.drawLine(0, this.yzeroAmps - (int)this.ymultAmps, this.winSize.width, this.yzeroAmps - (int)this.ymultAmps);
        i = 0;
        while (i != terms) {
            t = termWidth * i + termWidth / 2;
            double m = i == 0 || !this.logCheck.getState() ? this.ampcoef[i] : Math.max(0.0, Math.log(this.ampcoef[i]) / 6.0 + 1.0);
            y = this.yzeroAmps - (int)(m * this.ymultAmps);
            g.setColor(i == this.selHarm ? Color.yellow : Color.white);
            g.drawLine(t, this.yzeroAmps, t, y);
            g.fillOval(t - dotSize / 2, y - dotSize / 2, dotSize, dotSize);
            ++i;
        }
        g.setColor(Color.white);
        g.drawString("Phases", (this.winSize.width - fm.stringWidth("Phases")) / 2, 3 * this.graphHeight + 118);
        i = -2;
        while (i <= 2) {
            g.setColor(i == 0 ? gray2 : gray1);
            g.drawLine(0, this.yzeroPhas + i * (int)this.ymultPhas / 2, this.winSize.width, this.yzeroPhas + i * (int)this.ymultPhas / 2);
            ++i;
        }
        i = 1;
        while (i != terms) {
            t = termWidth * i + termWidth / 2;
            int y4 = this.yzeroPhas - (int)(this.phasecoef[i] * this.ymultPhas / Math.PI);
            g.setColor(i == this.selHarm ? Color.yellow : Color.white);
            g.drawLine(t, this.yzeroPhas, t, y4);
            g.fillOval(t - dotSize / 2, y4 - dotSize / 2, dotSize, dotSize);
            ++i;
        }
        g.setFont(new Font("SansSerif", 0, dotSize * 5 / 4));
        fm = g.getFontMetrics();
        i = 1;
        while (i != terms) {
            if (basef * (double)i > 11025.0) break;
            t = termWidth * i + termWidth / 2;
            g.setColor(i == this.selHarm ? Color.yellow : Color.white);
            if (this.hasSolo && !this.solos[i]) {
                g.setColor(Color.gray);
            }
            String pm = "-";
            if (this.mutes[i]) {
                pm = "M";
            }
            g.drawString(pm, t - fm.stringWidth(pm) / 2, 4 * this.graphHeight + 133);
            pm = "-";
            if (this.solos[i]) {
                pm = "S";
            }
            g.drawString(pm, t - fm.stringWidth(pm) / 2, 4 * this.graphHeight + 148);
            ++i;
        }
        realg.drawImage(this.dbimage, 0, 0, this);
    }

    void updateSound() {
        if (this.playThread != null) {
            this.playThread.soundChanged();
        }
    }

    void handleResize() {
        this.winSize = this.cv.getSize();
        if (this.winSize.width == 0) {
            return;
        }
        this.dbimage = this.createImage(this.winSize.width, this.winSize.height);
        this.yzeroFunc = this.graphHeight = Math.max(30, (this.winSize.height - 150) / 4);
        this.ymultFunc = 0.6 * (double)this.graphHeight;
        this.yzeroAmps = 3 * this.graphHeight + 84;
        this.ymultAmps = this.graphHeight - 12;
        this.yzeroPhas = Math.round(3.5f * (float)this.graphHeight) + 120;
        this.ymultPhas = 0.5 * (double)this.graphHeight - 6.0;
    }

    void setFunc() {
        double[] data = new double[2048];
        int terms = this.termBar.getValue();
        int i = 0;
        while (i != terms) {
            int sgn = (i & 1) == 1 ? -1 : 1;
            data[i * 2] = (double)sgn * this.ampcoef[i] * Math.cos(this.getCosPhase(i));
            data[i * 2 + 1] = (double)(-sgn) * this.ampcoef[i] * Math.sin(this.getCosPhase(i));
            ++i;
        }
        this.fft.transform(data, true);
        i = 0;
        while (i != 1024) {
            this.func[i] = data[i * 2] + this.ampcoef[0];
            ++i;
        }
        this.func[1024] = this.func[0];
        this.updateSound();
    }

    void transform() {
        double[] data = new double[2048];
        int i = 0;
        while (i != 1024) {
            data[i * 2] = this.func[i];
            ++i;
        }
        this.fft.transform(data, false);
        double epsilon = 1.0E-5;
        double mult = 0.001953125;
        int y = 0;
        while (y != 160) {
            double acoef = data[y * 2] * mult;
            double bcoef = -data[y * 2 + 1] * mult;
            if ((y & 1) == 1) {
                acoef = -acoef;
            } else {
                bcoef = -bcoef;
            }
            if (acoef < epsilon && acoef > -epsilon) {
                acoef = 0.0;
            }
            if (bcoef < epsilon && bcoef > -epsilon) {
                bcoef = 0.0;
            }
            if (y == 0) {
                this.ampcoef[0] = acoef / 2.0;
                this.phasecoef[0] = 0.0;
            } else {
                this.ampcoef[y] = Math.sqrt(acoef * acoef + bcoef * bcoef);
                if (this.ampcoef[y] == 0.0) {
                    this.phasecoef[y] = 0.0;
                } else {
                    this.phasecoef[y] = Math.atan2(-bcoef, acoef) + 1.5707963267948966;
                    if (this.phasecoef[y] > Math.PI) {
                        int n = y;
                        this.phasecoef[n] = this.phasecoef[n] - Math.PI * 2;
                    }
                }
            }
            ++y;
        }
        this.updateSound();
    }

    double getCosPhase(int i) {
        double p = this.phasecoef[i] - 1.5707963267948966;
        if (p < -Math.PI) {
            return p + Math.PI * 2;
        }
        return p;
    }

    double getCosSavePhase(int i) {
        double p = this.savePhasecoef[i] - 1.5707963267948966;
        if (p < -Math.PI) {
            return p + Math.PI * 2;
        }
        return p;
    }

    double getFreq() {
        double freq = 27.5 * Math.exp((double)this.freqBar.getValue() * 0.004158883084 * 2.0);
        this.dfreq0 = (int)(freq * 4096.0 / 22050.0) * 2;
        return (double)(22050 * this.dfreq0) / 8192.0;
    }

    int getTermWidth() {
        return this.winSize.width / this.termBar.getValue() & 0xFFFFFFFE;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.sineButton) {
            this.actionSine();
        } else if (e.getSource() == this.cosineButton) {
            this.actionCosine();
        } else if (e.getSource() == this.triangleButton) {
            this.actionTriangle();
        } else if (e.getSource() == this.sawtoothButton) {
            this.actionSawtooth();
        } else if (e.getSource() == this.squareButton) {
            this.actionSquare();
        } else if (e.getSource() == this.noiseButton) {
            this.actionNoise();
        } else if (e.getSource() == this.phaseButton) {
            this.actionPhaseShift();
        } else if (e.getSource() == this.clipButton) {
            this.actionClip();
        } else if (e.getSource() == this.resampleButton) {
            this.actionResample();
        } else if (e.getSource() == this.quantizeButton) {
            this.actionQuantize();
        } else if (e.getSource() == this.rectButton) {
            this.actionRect();
        } else if (e.getSource() == this.fullRectButton) {
            this.actionFullRect();
        } else if (e.getSource() == this.blankButton) {
            this.actionBlank();
        } else if (e.getSource() == this.saveButton) {
            this.actionSave();
        }
        if (e.getSource() != this.resampleButton) {
            this.resampleCount = 0;
        }
        if (e.getSource() != this.quantizeButton) {
            this.quantizeCount = 0;
        }
        this.cv.repaint();
    }

    void actionSine() {
        int x = 0;
        while (x != 1024) {
            this.func[x] = Math.sin((double)(x - 512) * 0.006135923151542565);
            ++x;
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void actionCosine() {
        int x = 0;
        while (x != 1024) {
            this.func[x] = Math.cos((double)(x - 512) * 0.006135923151542565);
            ++x;
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void actionTriangle() {
        int x = 0;
        while (x < 256) {
            this.func[x] = -2.4674 * (double)x / 512.0;
            this.func[x + 512] = 2.4674 * (double)x / 512.0;
            ++x;
        }
        while (x != 512) {
            this.func[x] = 2.4674 * (double)(x - 512) / 512.0;
            this.func[x + 512] = 2.4674 * (double)(512 - x) / 512.0;
            ++x;
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void actionSawtooth() {
        int x = 0;
        while (x != 1024) {
            this.func[x] = 1.5708 * (double)(x - 512) / 512.0;
            ++x;
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void actionSquare() {
        int x = 0;
        while (x != 512) {
            this.func[x] = -0.7854;
            this.func[x + 512] = 0.7854;
            ++x;
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void actionNoise() {
        int blockSize = 3;
        int x = 0;
        while (x != 1024 / blockSize) {
            double q = Math.random() * 2.0 - 1.0;
            int i = 0;
            while (i != blockSize) {
                this.func[x * blockSize + i] = q;
                ++i;
            }
            ++x;
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void actionPhaseShift() {
        int sh = 32;
        double[] copyf = new double[sh];
        int i = 0;
        while (i != sh) {
            copyf[i] = this.func[i];
            ++i;
        }
        i = 0;
        while (i != 1024 - sh) {
            this.func[i] = this.func[i + sh];
            ++i;
        }
        i = 0;
        while (i != sh) {
            this.func[1024 - sh + i] = copyf[i];
            ++i;
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void actionClip() {
        double mult = 1.2;
        int x = 0;
        while (x != 1024) {
            int n = x;
            this.func[n] = this.func[n] * mult;
            if (this.func[x] > 1.0) {
                this.func[x] = 1.0;
            } else if (this.func[x] < -1.0) {
                this.func[x] = -1.0;
            }
            ++x;
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void actionResample() {
        if (this.resampleCount == 0) {
            this.resampleCount = 32;
        }
        if (this.resampleCount == 1024) {
            return;
        }
        int x = 0;
        while (x != 1024) {
            int i = 1;
            while (i != this.resampleCount) {
                this.func[x + i] = this.func[x];
                ++i;
            }
            x += this.resampleCount;
        }
        this.func[1024] = this.func[0];
        this.transform();
        this.resampleCount *= 2;
    }

    void actionQuantize() {
        if (this.quantizeCount == 0) {
            this.quantizeCount = 8;
            this.origFunc = new double[1024];
            System.arraycopy(this.func, 0, this.origFunc, 0, 1024);
        }
        int x = 0;
        while (x != 1024) {
            this.func[x] = (double)Math.round(this.origFunc[x] * (double)this.quantizeCount) / (double)this.quantizeCount;
            ++x;
        }
        this.func[1024] = this.func[0];
        this.transform();
        this.quantizeCount /= 2;
    }

    void actionRect() {
        int x = 0;
        while (x != 1024) {
            if (this.func[x] < 0.0) {
                this.func[x] = 0.0;
            }
            ++x;
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void actionFullRect() {
        int x = 0;
        while (x != 1024) {
            if (this.func[x] < 0.0) {
                this.func[x] = -this.func[x];
            }
            ++x;
        }
        this.func[1024] = this.func[0];
        this.transform();
    }

    void actionBlank() {
        int x = 0;
        while (x <= 1024) {
            this.func[x] = 0.0;
            ++x;
        }
        x = 0;
        while (x != 160) {
            this.solos[x] = false;
            this.mutes[x] = false;
            ++x;
        }
        this.transform();
    }

    void actionSave() {
        int x = 0;
        while (x != 160) {
            this.saveAmpcoef[x] = this.ampcoef[x];
            this.savePhasecoef[x] = this.phasecoef[x];
            ++x;
        }
        this.cv.repaint();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.termBar) {
            this.termLabel.setText("Terms: " + this.termBar.getValue());
        } else if (e.getSource() == this.freqBar) {
            this.freqLabel.setText("Frequency: " + (int)this.getFreq() + " Hz");
        }
        this.updateSound();
        this.cv.repaint();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.soundCheck && this.soundCheck.getState() && this.playThread == null) {
            this.playThread = new PlayThread();
            this.playThread.start();
        }
        if (e.getSource() == this.superCheck) {
            this.updateSound();
        }
        this.cv.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.cv.requestFocusInWindow();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && this.selHarm != -1 && this.sel != 4 && this.sel != 5) {
            int i = 0;
            while (i != 160) {
                this.ampcoef[i] = 0.0;
                this.phasecoef[i] = 0.0;
                ++i;
            }
            this.ampcoef[this.selHarm] = 1.0;
            this.setFunc();
            this.cv.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.dragging = true;
        this.mouse(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int oldCoef = this.selHarm;
        int oldSel = this.sel;
        this.dragX = x;
        this.dragY = y;
        this.selHarm = -1;
        this.sel = 0;
        if (y < 2 * this.graphHeight) {
            this.sel = 1;
        } else {
            this.selHarm = x / this.getTermWidth();
            if (this.selHarm >= this.termBar.getValue()) {
                this.selHarm = -1;
            } else if (this.selHarm != -1) {
                this.sel = y < 3 * this.graphHeight + 105 ? 2 : (y < 4 * this.graphHeight + 120 ? 3 : (y < 4 * this.graphHeight + 135 ? 4 : 5));
            }
        }
        if (this.selHarm != oldCoef || this.sel != oldSel) {
            this.cv.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseMoved(e);
        if ((e.getModifiers() & 4) != 0 && this.selHarm != -1) {
            this.termBar.setValue(this.selHarm + 1);
            this.termLabel.setText("Terms: " + (this.selHarm + 1));
            this.cv.repaint();
        }
        if ((e.getModifiers() & 0x10) == 0) {
            return;
        }
        this.dragging = true;
        this.mouse(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if ((e.getModifiers() & 0x10) == 0) {
            return;
        }
        this.dragging = false;
        if (this.sel == 1) {
            this.transform();
        } else if (this.sel != 0) {
            this.setFunc();
        }
        this.cv.repaint();
    }

    void mouse(MouseEvent e) {
        if (this.sel == 0) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        switch (this.sel) {
            case 1: {
                this.mouseFunc(x, y);
                break;
            }
            case 2: {
                this.mouseAmp(x, y);
                break;
            }
            case 3: {
                this.mousePhase(x, y);
                break;
            }
            case 4: {
                this.mouseMutes(e, x, y);
                break;
            }
            case 5: {
                this.mouseSolos(e, x, y);
            }
        }
        this.resampleCount = 0;
        this.quantizeCount = 0;
    }

    void mouseAmp(int x, int y) {
        if (this.selHarm == -1) {
            return;
        }
        double coef = Math.min(1.0, Math.max(-1.0, (double)(this.yzeroAmps - y) / this.ymultAmps));
        if (this.selHarm > 0) {
            if (coef <= 0.0) {
                coef = 0.0;
            } else if (this.logCheck.getState()) {
                coef = Math.exp(6.0 * (coef - 1.0));
            }
        }
        if (this.ampcoef[this.selHarm] == coef) {
            return;
        }
        this.ampcoef[this.selHarm] = coef;
        this.updateSound();
        this.cv.repaint();
    }

    void mouseFunc(int x, int y) {
        if (this.dragX == x) {
            this.mouseFuncPoint(x, y);
            this.dragY = y;
        } else {
            int x1 = x < this.dragX ? x : this.dragX;
            int y1 = x < this.dragX ? y : this.dragY;
            int x2 = x > this.dragX ? x : this.dragX;
            int y2 = x > this.dragX ? y : this.dragY;
            this.dragX = x;
            this.dragY = y;
            x = x1;
            while (x <= x2) {
                this.mouseFuncPoint(x, y1 + (y2 - y1) * (x - x1) / (x2 - x1));
                ++x;
            }
        }
    }

    void mouseFuncPoint(int x, int y) {
        int periodWidth = this.winSize.width / 3;
        int lox = x % periodWidth * 1024 / periodWidth;
        int hix = (x % periodWidth + 1) * 1024 / periodWidth - 1;
        double val = Math.min(1.0, Math.max(-1.0, (double)(this.yzeroFunc - y) / this.ymultFunc));
        while (lox <= hix) {
            this.func[lox] = val;
            ++lox;
        }
        this.func[1024] = this.func[0];
        this.cv.repaint();
    }

    void mousePhase(int x, int y) {
        if (this.selHarm <= 0) {
            return;
        }
        double coef = Math.PI * Math.min(1.0, Math.max(-1.0, (double)(this.yzeroPhas - y) / this.ymultPhas));
        if (this.phasecoef[this.selHarm] == coef) {
            return;
        }
        this.phasecoef[this.selHarm] = coef;
        this.cv.repaint();
    }

    void mouseMutes(MouseEvent e, int x, int y) {
        if (e.getID() != 501 || this.selHarm == -1) {
            return;
        }
        this.mutes[this.selHarm] = !this.mutes[this.selHarm];
        this.cv.repaint();
    }

    void mouseSolos(MouseEvent e, int x, int y) {
        if (e.getID() != 501 || this.selHarm == -1) {
            return;
        }
        this.solos[this.selHarm] = !this.solos[this.selHarm];
        this.hasSolo = this.solos[this.selHarm];
        int i = 0;
        while (i != 160) {
            this.solos[i] = i == this.selHarm ? this.hasSolo : false;
            ++i;
        }
        this.cv.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.selHarm == -1 || this.sel != 2 && this.sel != 3 || this.selHarm == 0 && this.sel == 3) {
            return;
        }
        double d = 0.1;
        int k = e.getKeyCode();
        if (k == 40 || k == 34 || k == 45 || k == 98 || k == 109 || k == 225) {
            d = -0.1;
        } else if (k != 38 && k != 33 && k != 61 && k != 104 && k != 107 && k != 224) {
            return;
        }
        if (e.isShiftDown()) {
            d /= 100.0;
        }
        if (e.isControlDown()) {
            d /= 100.0;
        }
        if (this.sel == 2) {
            this.ampcoef[this.selHarm] = Double.parseDouble(this.ampFormat.format(Math.min(1.0, Math.max((double)(this.selHarm > 0 ? 0 : -1), this.ampcoef[this.selHarm] + d))));
        } else {
            this.phasecoef[this.selHarm] = Double.parseDouble(this.phaseFormat.format(Math.min(180.0, Math.max(-180.0, this.phasecoef[this.selHarm] / Math.PI * 180.0 + d * 100.0)))) * Math.PI / 180.0;
        }
        this.setFunc();
        this.cv.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.cv.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.handleResize();
        this.cv.repaint(100L);
    }

    @Override
    public void windowClosing(WindowEvent ev) {
        this.dispose();
        this.applet.ogf = null;
        this.applet.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent ev) {
    }

    @Override
    public void windowClosed(WindowEvent ev) {
    }

    @Override
    public void windowDeactivated(WindowEvent ev) {
    }

    @Override
    public void windowDeiconified(WindowEvent ev) {
    }

    @Override
    public void windowIconified(WindowEvent ev) {
    }

    @Override
    public void windowOpened(WindowEvent ev) {
    }

    class PlayThread
    extends Thread {
        boolean changed;

        PlayThread() {
        }

        public void soundChanged() {
            this.changed = true;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            playFFT = new FFT(4096);
            playfunc = null;
            b = null;
            offset = 0;
            format = new AudioFormat(22050.0f, 16, 1, true, true);
            line = null;
            try {
                line = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, format));
                line.open(format, 4096);
                line.start();
                if (true) ** GOTO lbl62
            }
            catch (Exception e) {
                e.printStackTrace();
                FourierFrame.this.playThread = null;
                return;
            }
            do {
                if (playfunc == null || this.changed) {
                    playfunc = new double[8192];
                    terms = FourierFrame.this.termBar.getValue();
                    mx = 2.0;
                    this.changed = false;
                    i = 1;
                    while (i != terms) {
                        if (!(FourierFrame.this.hasSolo && !FourierFrame.this.solos[i] || FourierFrame.this.mutes[i])) {
                            dfreq = FourierFrame.this.dfreq0 * i;
                            if (dfreq >= 4096) break;
                            sgn = (i & 1) == 1 ? -1 : 1;
                            playfunc[dfreq] = (double)sgn * FourierFrame.this.ampcoef[i] * Math.cos(FourierFrame.this.getCosPhase(i));
                            playfunc[dfreq + 1] = (double)(-sgn) * FourierFrame.this.ampcoef[i] * Math.sin(FourierFrame.this.getCosPhase(i));
                            if (FourierFrame.this.superCheck.getState()) {
                                v0 = dfreq;
                                playfunc[v0] = playfunc[v0] + (double)sgn * FourierFrame.this.saveAmpcoef[i] * Math.cos(FourierFrame.this.getCosSavePhase(i));
                                v1 = dfreq + 1;
                                playfunc[v1] = playfunc[v1] + (double)(-sgn) * FourierFrame.this.saveAmpcoef[i] * Math.sin(FourierFrame.this.getCosSavePhase(i));
                            }
                        }
                        ++i;
                    }
                    playFFT.transform(playfunc, true);
                    i = 0;
                    while (i != 4096) {
                        dy = playfunc[i * 2];
                        if (dy > mx) {
                            mx = dy;
                        }
                        if (dy < -mx) {
                            mx = -dy;
                        }
                        ++i;
                    }
                    b = new byte[8192];
                    mult = 32767.0 / mx;
                    i = 0;
                    while (i != 4096) {
                        x = (short)(playfunc[i * 2] * mult);
                        b[i * 2] = (byte)(x / 256);
                        b[i * 2 + 1] = (byte)(x & 255);
                        ++i;
                    }
                }
                ss = 4096;
                if (offset >= b.length) {
                    offset = 0;
                }
                line.write(b, offset, ss);
                offset += ss;
lbl62:
                // 2 sources

            } while (FourierFrame.this.soundCheck.getState() && FourierFrame.this.applet.ogf != null);
            FourierFrame.this.playThread = null;
        }
    }
}

